/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.impl;

import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.enums.TrafficType;
import com.cisco.pt.ipc.impl.IPCObjectImpl;
import com.cisco.pt.ipc.sim.Device;
import com.cisco.pt.ipc.sim.FlowChartNode;
import com.cisco.pt.ipc.sim.FrameDecision;
import com.cisco.pt.ipc.sim.FrameInstance;
import com.cisco.pt.ipc.sim.UserTraffic;
import com.cisco.pt.ipc.sim.pdu.Pdu;
import com.cisco.pt.ipc.sim.port.Port;
import com.cisco.pt.ptmp.PacketTracerSession;

public class FrameInstanceImpl
extends IPCObjectImpl
implements FrameInstance {
    public FrameInstanceImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    public TrafficType getUserTrafficType() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getUserTrafficType");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: FrameInstanceImpl.getUserTrafficType");
        }
        return TrafficType.fromIntValue(returnMessage.getIntValue());
    }

    public String getDestinationString() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getDestinationString");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    public String getSourceString() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getSourceString");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    public Device getDevice() {
        return this.getFactory().getDevice(this);
    }

    public Device getPreviousDevice() {
        return this.getFactory().getPreviousDevice(this);
    }

    public Pdu getInFrame() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getInFrame");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (Pdu)returnMessage.getObjectValue();
    }

    public Pdu getOutFrame() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getOutFrame");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (Pdu)returnMessage.getObjectValue();
    }

    public Port getInPort() {
        return this.getFactory().getInPort(this);
    }

    public Port getOutPort(int outPortIndex) {
        return this.getFactory().getOutPort(this, outPortIndex);
    }

    public int getOutPortCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getOutPortCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: FrameInstanceImpl.getOutPortCount");
        }
        return returnMessage.getIntValue();
    }

    public void addDecision(String id, String description, boolean isOsiIn, int osiLayer) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addDecision");
        newCall.addStringParameter(id);
        newCall.addQStringParameter(description);
        newCall.addBoolParameter(isOsiIn);
        newCall.addIntParameter(osiLayer);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public FlowChartNode getFlowChartNodeAt(int nodeIndex) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getFlowChartNodeAt");
        newCall.addIntParameter(nodeIndex);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (FlowChartNode)returnMessage.getObjectValue();
    }

    public FrameDecision getFrameDecsionAt(int index) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getFrameDecsionAt");
        newCall.addIntParameter(index);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (FrameDecision)returnMessage.getObjectValue();
    }

    public int getFlowChartNodeCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getFlowChartNodeCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: FrameInstanceImpl.getFlowChartNodeCount");
        }
        return returnMessage.getIntValue();
    }

    public String getDecisionAt(int index) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getDecisionAt");
        newCall.addIntParameter(index);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    public void setFrameSent(boolean sent) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setFrameSent");
        newCall.addBoolParameter(sent);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public boolean isFrameSent() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isFrameSent");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: FrameInstanceImpl.isFrameSent");
        }
        return returnMessage.getBoolValue();
    }

    public void setFrameBuffered(boolean buffered) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setFrameBuffered");
        newCall.addBoolParameter(buffered);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public boolean isFrameBuffered() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isFrameBuffered");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: FrameInstanceImpl.isFrameBuffered");
        }
        return returnMessage.getBoolValue();
    }

    public void setFrameDropped(boolean dropped) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setFrameDropped");
        newCall.addBoolParameter(dropped);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public boolean isFrameDropped() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isFrameDropped");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: FrameInstanceImpl.isFrameDropped");
        }
        return returnMessage.getBoolValue();
    }

    public void setFrameNotForwarded(boolean notForwarded) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setFrameNotForwarded");
        newCall.addBoolParameter(notForwarded);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public boolean isFrameNotForwarded() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isFrameNotForwarded");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: FrameInstanceImpl.isFrameNotForwarded");
        }
        return returnMessage.getBoolValue();
    }

    public void setFrameAccepted(boolean accepted) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setFrameAccepted");
        newCall.addBoolParameter(accepted);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public boolean isFrameAccepted() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isFrameAccepted");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: FrameInstanceImpl.isFrameAccepted");
        }
        return returnMessage.getBoolValue();
    }

    public void setFrameUnexpected(boolean unexpected) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setFrameUnexpected");
        newCall.addBoolParameter(unexpected);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public boolean isFrameUnexpected() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isFrameUnexpected");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: FrameInstanceImpl.isFrameUnexpected");
        }
        return returnMessage.getBoolValue();
    }

    public boolean isFrameCollidedOnLink() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isFrameCollidedOnLink");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: FrameInstanceImpl.isFrameCollidedOnLink");
        }
        return returnMessage.getBoolValue();
    }

    public boolean isFrameCollidedAtDevice() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isFrameCollidedAtDevice");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: FrameInstanceImpl.isFrameCollidedAtDevice");
        }
        return returnMessage.getBoolValue();
    }

    public boolean isFrameOnTransit() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isFrameOnTransit");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: FrameInstanceImpl.isFrameOnTransit");
        }
        return returnMessage.getBoolValue();
    }

    public int getQosStampColorCode() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getQosStampColorCode");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: FrameInstanceImpl.getQosStampColorCode");
        }
        return returnMessage.getIntValue();
    }

    public int getInQosStampColorCode() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getInQosStampColorCode");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: FrameInstanceImpl.getInQosStampColorCode");
        }
        return returnMessage.getIntValue();
    }

    public int getOutQosStampColorCode() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getOutQosStampColorCode");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: FrameInstanceImpl.getOutQosStampColorCode");
        }
        return returnMessage.getIntValue();
    }

    public int getTransitTime() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getTransitTime");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: FrameInstanceImpl.getTransitTime");
        }
        return returnMessage.getIntValue();
    }

    public int getPercentageSent() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getPercentageSent");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: FrameInstanceImpl.getPercentageSent");
        }
        return returnMessage.getIntValue();
    }

    public long getStartSimTime() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getStartSimTime");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: FrameInstanceImpl.getStartSimTime");
        }
        return returnMessage.getLongValue();
    }

    public UserTraffic getTrafficSource() {
        return this.getFactory().getTrafficSource(this);
    }
}

